//=============================================================================
// Trigger: senses things happening in its proximity and generates 
// sends Trigger/UnTrigger to actors whose names match 'EventName'.
//=============================================================================
class TimedTrigger extends Triggers;

var() float TimeTillEventTriggered;
var() bool bLoopTimeTillTrigger;

//=============================================================================
// AI related functions

function Trigger(Actor Other, Pawn EventInstigator)
{
 SetTimer(TimeTillEventTriggered, bLoopTimeTillTrigger);
}

function Timer()
{
local Actor A;
		// Broadcast the Trigger message to all matching actors.
		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
			{
				A.Trigger(None, None);
			}

}



defaultproperties
{
     Texture=Texture'Engine.S_Trigger'
}
